/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.algorithms.Direction;
import cz.insophy.inplan.planning.mokos.AbstractPositioner;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.util.Comparators;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CumulativePositioner
extends AbstractPositioner {
    @Override
    protected AbstractPositioner.ActSpaceCollector getActionActCollector(GeneralizedActionRequest gar, Action action, WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, boolean useTools) {
        return new CumASpaceCollector(gar, action, wps, removedRebs, ss, bom, time, useTools);
    }

    @Override
    protected RebuildType getRebuildTypeOf(WorkplaceActivity wa, Workplace wp) {
        if (wa instanceof RebuildActivity) {
            return ((RebuildActivity)wa).getToType();
        }
        if (wa instanceof CumulativeWorkplaceActivity) {
            CumulativeWorkplaceActivity cuma = (CumulativeWorkplaceActivity)wa;
            ActionActivity aa = cuma.getActionActivities().iterator().next();
            Action action = aa.getAction();
            String rtName = action.getRebuildType();
            return wp.getRebuildType(rtName);
        }
        return null;
    }

    @Override
    protected AbstractPositioner.BubbleSeeker getFreeSpaceSeeker(WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, Action act, boolean useTools) {
        Preconditions.checkNotNull(act);
        Preconditions.checkArgument(act instanceof CumulativeAction);
        return new CumFreeSpaceSeeker(wps, ss, bom, time, (CumulativeAction)act, useTools);
    }

    private static boolean smtFitsInCumWa(CumulativeWorkplaceActivity cwa, CumulativeAction act, long start) {
        boolean fits = true;
        fits &= cwa.getCumulationType().equals(act.getCumulationType());
        fits &= Comparators.compare(cwa.getRemainingCapacity(act), act.getGranularity(), 1.0E-7) >= 0;
        fits &= cwa.getDuration() == act.getProductionTime();
        fits &= cwa.getStart() >= start;
        Set<ActionActivity> aas = cwa.getActionActivities();
        if (!aas.isEmpty()) {
            ActionActivity aa = aas.iterator().next();
            String rt = aa.getAction().getRebuildType();
            fits &= rt.equals(act.getRebuildType());
        }
        return fits;
    }

    protected static class CumASpaceCollector
    extends AbstractPositioner.ActSpaceCollector {
        private Workplace wp;
        private double collectedQty;

        public CumASpaceCollector(GeneralizedActionRequest gar, Action action, WorkplaceSchedule wps, Set<RebuildActivity> removedRebs, StoreSchedule ss, Bom bom, long time, boolean useTools) {
            super(gar, action, wps, removedRebs, ss, bom, time, Direction.FORWARD, useTools);
            this.wp = wps.getWorkplace();
            this.collectedQty = 0.0;
        }

        @Override
        public boolean isCollectingComplete() {
            GeneralizedActionRequest gar = this.getGar();
            return Comparators.compare(this.collectedQty, gar.getAmount(), 1.0E-7) >= 0;
        }

        @Override
        protected List<ActivityChange> process(WorkplaceActivity wa) {
            ArrayList<ActivityChange> aChs;
            GeneralizedActionRequest gar = this.getGar();
            CumulativeAction action = (CumulativeAction)this.getAction();
            double remainingQty = gar.getAmount() - this.collectedQty;
            if (wa instanceof Bubble) {
                Bubble bub = (Bubble)wa;
                long prodTime = action.getProductionTime();
                int slotNo = bub.isLast() ? (int)Math.ceil(gar.getAmount() / action.getMaxFill()) : (int)(bub.getDuration() / prodTime);
                if (slotNo == 0) {
                    this.failAt(bub.getEnd());
                    aChs = Lists.newArrayList();
                } else {
                    aChs = Lists.newArrayList();
                    for (int i = 0; i < slotNo; ++i) {
                        double qty = Math.min(remainingQty, action.getMaxFill());
                        long start = bub.getStart() + (long)i * prodTime;
                        long end = start + prodTime;
                        aChs.add(new ActivityChange(new ActionActivity(start, end, this.wp, action, qty), ActivityChange.ChangeType.ADDED));
                        this.updateActsInterval(start, end);
                        if (qty > 1.0E-7) {
                            this.collectedQty += qty;
                        }
                        if (Comparators.compare(this.collectedQty, gar.getAmount(), 1.0E-7) < 0) {
                            remainingQty -= qty;
                            continue;
                        }
                        break;
                    }
                }
            } else if (wa instanceof CumulativeWorkplaceActivity) {
                CumulativeWorkplaceActivity cwa = (CumulativeWorkplaceActivity)wa;
                double cwaCap = cwa.getRemainingCapacity(action);
                if (CumulativePositioner.smtFitsInCumWa(cwa, action, this.getTime())) {
                    double qty = Math.min(cwaCap, Math.min(remainingQty, action.getMaxFill()));
                    this.collectedQty += qty;
                    long start = cwa.getStart();
                    long end = cwa.getEnd();
                    aChs = Lists.newArrayList(new ActivityChange(new ActionActivity(start, end, this.wp, action, qty), ActivityChange.ChangeType.ADDED));
                    this.updateActsInterval(start, end);
                } else {
                    this.failAt(Math.max(wa.getStart(), this.getTime()));
                    aChs = null;
                }
            } else if (wa instanceof OfflineActivity && !((OfflineActivity)wa).isDividing()) {
                aChs = null;
            } else {
                this.failAt(wa.getStart());
                aChs = null;
            }
            return aChs;
        }
    }

    protected static class CumFreeSpaceSeeker
    extends AbstractPositioner.BubbleSeeker {
        private final CumulativeAction act;

        public CumFreeSpaceSeeker(WorkplaceSchedule wps, StoreSchedule ss, Bom bom, long time, CumulativeAction act, boolean useTools) {
            super(wps, ss, bom, time, useTools);
            this.act = act;
        }

        @Override
        protected List<ActivityChange> process(WorkplaceActivity wa) {
            if (wa instanceof Bubble) {
                this.setNextSpace(wa);
            } else if (wa instanceof CumulativeWorkplaceActivity) {
                CumulativeWorkplaceActivity cwa = (CumulativeWorkplaceActivity)wa;
                if (CumulativePositioner.smtFitsInCumWa(cwa, this.act, this.getTime())) {
                    this.setNextSpace(wa);
                }
            } else if (wa instanceof OfflineActivity && wa.getEnd() == Long.MAX_VALUE) {
                this.failAt(wa.getStart());
            }
            return null;
        }
    }
}

